
Type TSliderJoint Extends TJoint

	'#Region private members
	Field _body1:TBody
	Field _body2:TBody
	
	Field _biasFactor:Float =.2
	Field _slop:Float =.01
	Field _softness:Float = 0
	Field _min:Float
	Field _max:Float
	Field _breakpoint:Float = MathHelper.MaxValueF
	
	Field _jointError:Float
	Field _anchor1:Vector2 = Vector2.Zero()
	Field _anchor2:Vector2 = Vector2.Zero()
	Field _worldAnchor1:Vector2 = Vector2.Zero()
	Field _worldAnchor2:Vector2 = Vector2.Zero()
	Field _upperLimitViolated:Int = False
	Field _lowerLimitViolated:Int = False
	Field _r1:Vector2 = Vector2.Zero()
	Field _r2:Vector2 = Vector2.Zero()
	Field _velocityBias:Float
	Field _accumulatedImpulse:Float
	Field _worldAnchorDifferenceNormalized:Vector2 = Vector2.Zero()
	Field _effectiveMass:Float
	'#End Region 
	
	'#Region Public Properties getter/setters
	Method GetBody1:TBody()
		Return _body1
	End Method
	
	Method SetBody1(value:TBody)
		_body1 = value
	End Method
	
	Method GetBody2:TBody()
		Return _body2
	End Method
	
	Method SetBody2(value:TBody)
		_body2 = value
	End Method
	
	Method GetBiasFactor:Float()
		Return _biasFactor
	End Method
	
	Method SetBiasFactor(value:Float)
		_biasFactor = value
	End Method
	
	Method GetSoftness:Float()
		Return _softness
	End Method
	
	Method SetSoftness(value:Float)
		_softness = value
	End Method
	
	Method GetSlop:Float()
		Return _slop
	End Method
	
	Method SetSlop(value:Float)
		_slop = value
	End Method
	
	Method GetBreakPoint:Float()
		Return _breakpoint
	End Method
	
	Method SetBreakPoint(value:Float)
		_breakpoint = value
	End Method
	
	Method GetJointError:Float()
		Return _jointError
	End Method
	
	Method GetMin:Float()
		Return _min
	End Method
	
	Method SetMin(value:Float)
		_min = value
	End Method
	
	Method GetMax:Float()
		Return _max
	End Method
	
	Method SetMax(value:Float)
		_max = value
	End Method
	
	Method GetAnchor1:Vector2()
		Return _anchor1.Copy()
	End Method
	
	Method SetAnchor1(value:Vector2)
		_anchor1.X = value.X
		_anchor1.Y = value.Y
		_body1.GetBodyMatrixRef(_body1MatrixTemp)
		Vector2.TransformNormalRef(_anchor1, _body1MatrixTemp, _r1)
		Vector2.AddVectorsRef(_body1._position, _r1, _worldAnchor1)
	End Method
	
	Method GetAnchor2:Vector2()
		Return _anchor2.Copy()
	End Method
	
	Method SetAnchor2(value:Vector2)
		_anchor2.X = value.X
		_anchor2.Y = value.Y
		_body2.GetBodyMatrixRef(_body2MatrixTemp)
		Vector2.TransformNormalRef(_anchor2, _body2MatrixTemp, _r2)
		Vector2.AddVectorsRef(_body2._position, _r2, _worldAnchor2)		
	End Method
	
	Method GetWorldAnchor1:Vector2()
		Return _worldAnchor1.Copy()
	End Method
	
	Method GetWorldAnchor2:Vector2()
		Return _worldAnchor2.Copy()
	End Method
	
	Field _anchor:Vector2 = Vector2.Zero()
	Method GetCurrentAnchorPosition:Vector2()
		Vector2.AddVectorsRef(_body1._position, _r1, _anchor)	'anchor moves once simulator starts
		Return _anchor.Copy()
	End Method
	'#End Region 
	
	
	Function Create:TSliderJoint(body1:TBody, anchor1:Vector2, body2:TBody, anchor2:Vector2, minDistance:Float, maxDistance:Float)
		Local joint:TSliderJoint = New TSliderJoint
		joint._body1 = body1
		joint._body2 = body2
		joint._anchor1.Set(anchor1)
		joint._anchor2.Set(anchor2)
		
		joint._min = minDistance
		joint._max = maxDistance
		
		'initialized the world anchors (only needed to give valid values to the worldanchor properties)
		joint.SetAnchor1(anchor1)
		joint.SetAnchor2(anchor2)
		Return joint
	End Function
	
	
	'#Region Prestep variables
	Field _distance:Float
	Field _angularImpulse:Float = 0
	Field _body1MatrixTemp:TMatrix = TMatrix.Identity()
	Field _body1InverseMass:Float
	Field _body1InverseMomentOfInertia:Float
	
	Field _body2MatrixTemp:TMatrix = TMatrix.Identity()
	Field _body2InverseMass:Float
	Field _body2InverseMomentOfInertia:Float
	
	Field _r1cn:Float
	Field _r2cn:Float
	Field _knormal:Float
	Field _accumulatedImpulseVector:Vector2 = Vector2.Zero()
	field _worldAnchorDifference:Vector2 = Vector2.Zero()
	'#End Region 
	Method PreStep(inversedt:Float)
		If Abs(_jointError) > _breakpoint Then Return
		
		' set some temp varaibles
		_body1InverseMass = _body1._inverseMass
		_body1InverseMomentOfInertia = _body1._inverseMomentOfInertia
		_body2InverseMass = _body2._inverseMass
		_body2InverseMomentOfInertia = _body2._inverseMomentOfInertia
		
		'calc r1 and r2 from anchors
		_body1.GetBodyMatrixRef(_body1MatrixTemp)
		_body2.GetBodyMatrixRef(_body2MatrixTemp)
		Vector2.TransformNormalRef(_anchor1, _body1MatrixTemp, _r1)
		Vector2.TransformNormalRef(_anchor2, _body2MatrixTemp, _r2)
		
		'calc diff between anchor positions
		Vector2.AddVectorsRef(_body1._position, _r1, _worldAnchor1)
		Vector2.AddVectorsRef(_body2._position, _r2, _worldAnchor2)
		Vector2.SubtractVectorsRef(_worldAnchor2, _worldAnchor1, _worldAnchorDifference)
		
		_distance = _worldAnchorDifference.Length()

		_jointError = 0
		
		If _distance > _max Then
			If _lowerLimitViolated Then
				_accumulatedImpulse = 0
				_lowerLimitViolated = False
			End If
			_upperLimitViolated = True
			If _distance < _max + _slop Then
				_jointError = 0 'allow some slop
			Else
				_jointError = _distance - _max
			End If
		Else If _distance < _min Then
			If _upperLimitViolated Then
				_accumulatedImpulse = 0
				_upperLimitViolated = False
			End If
			_lowerLimitViolated = True
			If _distance > _min - _slop Then
				_jointError = 0
			Else
				_jointError = _distance - _min
			End If
		Else
			_upperLimitViolated = False
			_lowerLimitViolated = False
			_jointError = 0
			_accumulatedImpulse = 0
		End If
		
		'normalize the difference vector
		If _distance = 0 Then
			_distance = MathHelper.PositiveInfinityF ' distance = 0 --> error (fix)
		End If
		Vector2.ScaleRef(_worldAnchorDifference, 1 / _distance, _worldAnchorDifferenceNormalized)
		
		'calc velocity bias
		_velocityBias = _biasFactor * inverseDt * (_jointError)

		
		'calc mass normal (effective mass in relation to constraint)
		_r1cn = Calculator.CrossVV(_r1, _worldAnchorDifferenceNormalized)
		_r2cn = Calculator.CrossVV(_r2, _worldAnchorDifferenceNormalized)
		_knormal = _body1InverseMass + _body2InverseMass + _body1InverseMomentOfInertia * _r1cn * _r1cn + _body2InverseMomentOfInertia * _r2cn * _r2cn
		_effectiveMass = 1 / (_knormal + _softness)
		
		'convert scalar accumulatd impulse to vector
		Vector2.ScaleRef(_worldAnchorDifferenceNormalized, _accumulatedIMpulse, _accumulatedImpulseVector)
		
		'appl accumulated impulses (warm starting)
		_body2.ApplyImmediateImpulse(_accumulatedImpulseVector)
		_angularImpulse = Calculator.CrossVV(_r2, _accumulatedImpulseVector)
		_body2.ApplyAngularImpulse(_angularImpulse)
		
		Vector2.ScaleRef(_accumulatedImpulseVector, - 1, _accumulatedImpulseVector)
		_body1.ApplyImmediateImpulse(_accumulatedImpulseVector)
		_angularImpulse = Calculator.CrossVV(_r1, _accumulatedImpulseVector)
		_body1.ApplyAngularImpulse(_angularImpulse)
	End Method
	
	'#Region update variables
	Field _dv:Vector2 = Vector2.Zero()
	Field _impulse:Vector2 = Vector2.Zero()
	Field _impulseMagnitude:Float
	Field _dvNormal:Float
	Field _angularVelocityComponent1:Vector2 = Vector2.Zero()
	Field _angularVelocityComponent2:Vector2 = Vector2.Zero()
	Field _velocity1:Vector2 = Vector2.Zero()
	Field _velocity2:Vector2 = Vector2.Zero()
	'#End Region 
	Method Update()
		If Abs(_jointError) > _breakpoint Then Return
		If Not(_upperLimitViolated) And Not(_lowerLimitViolated) Then Return

		'calc velocity anchor points (angular component + linear)
		Calculator.CrossFVRef(_body1._angularVelocity, _r1, _angularVelocityComponent1)
		Vector2.AddVectorsRef(_body1._linearVelocity, _angularVelocityComponent1, _velocity1)
		
		Calculator.CrossFVRef(_body2._angularVelocity, _r2, _angularVelocityComponent2)
		Vector2.AddVectorsRef(_body2._linearVelocity, _angularVelocityComponent2, _velocity2)
		
		'calc velocity difference
		Vector2.SubtractVectorsRef(_velocity2, _velocity1, _dv)
		
		'map velocity difference into constraint space
		_dvNormal = Vector2.Dot(_dv, _worldAnchorDifferenceNormalized)
		
		'calc impulse magnitude
		_impulseMagnitude = (- _velocityBias - _dvNormal - _softness * _accumulatedImpulse) * _effectiveMass ' not sure if softness is implemented correctly

		Local oldAccumulatedImpulse:Float = _accumulatedImpulse

		If _upperLimitViolated Then
			_accumulatedImpulse = Min(oldAccumulatedImpulse + _impulseMagnitude, 0)
		Else If _lowerLimitViolated Then
			_accumulatedImpulse = Max(oldAccumulatedImpulse + _impulseMagnitude, 0)
		End If
		
		_impulseMagnitude = _accumulatedImpulse - oldAccumulatedImpulse

		'convert scalar impulse to vector
		Vector2.ScaleRef(_worldAnchorDifferenceNormalized, _impulseMagnitude, _impulse)

		'apply impulse
		_body2.ApplyImmediateImpulse(_impulse)
		_angularImpulse = Calculator.CrossVV(_r2, _impulse)
		_body2.ApplyAngularImpulse(_angularImpulse)

		Vector2.ScaleRef(_impulse, - 1, _impulse)
		_body1.ApplyImmediateImpulse(_impulse)
		_angularImpulse = Calculator.CrossVV(_r1, _impulse)
		_body1.ApplyAngularImpulse(_angularImpulse)
		
	End Method
End Type
